﻿#pragma once
#include "Texture.h"

namespace RTCam {

// A depth stencil with a texture backing.
class RenderTarget : public Texture
{
public:
	explicit RenderTarget(_In_z_ const char* name);
	~RenderTarget(void);

	void Init(_In_ ID3D11Device1* device, size_t width, size_t height, DXGI_FORMAT format);
	
	virtual void ReleaseResources() override;

	ComPtr<ID3D11RenderTargetView> m_renderTargetView;

	static const DXGI_FORMAT rtTexFormatStandard = DXGI_FORMAT_B8G8R8A8_UNORM; // Standard colors
	static const DXGI_FORMAT rtTexFormatHDR = DXGI_FORMAT_R16G16B16A16_FLOAT; // HDR
	static const DXGI_FORMAT rtTexFormatHDRHalf = DXGI_FORMAT_R11G11B10_FLOAT; // HDR (Lower precision)
};


} // end namespace